unit MMTimerUnit;
//       (property Stoped)
interface

uses Windows, Classes, Dialogs;

// -------------------------------------------------------------------------
//     TMMTimer
// -------------------------------------------------------------------------
// 1.  TMethod (   System)
//        :
//
// type TMethod  = record
//     Code : Pointer;  //     
//     Data : Pointer;  //     
//  end;
//
// 2.   type UINT = LongWord;  (   Windows)
// 3.   type DWORD = Longword; (   Windows)
// -------------------------------------------------------------------------
type TMMTimer = class(TObject)
private
    // -----------------------------------------------------------------
    fOnMMTimer :  TNotifyEvent;  //    OnMMTimer
    fDelay     :  cardinal;	     //   (msec)
    fCicle     :  boolean;       // False -  
                                 // True -   
    fEnabled   :  boolean;       //   ;
    // -----------------------------------------------------------------
    //    
    fMhetod    :  TMethod;       //  TMMTimer.RunExternalProc  Self
    fpMhetod   : ^TMethod;       //   fMhetod
    // -----------------------------------------------------------------
    fuID       :  UINT;          //   ;
    fStoped    :  boolean;       //  "  "
    fEvnID     :  cardinal;
    // -----------------------------------------------------------------
    //       OnMMTimer
    procedure RunExternalProc();
    //         
    procedure RunTimerCicle(RqEnabled : boolean);
public
    constructor Create();
    procedure   Free;
    // -----------------------------------------------------------------
    //    (ms)
    property Interval  : cardinal read fDelay write fDelay;
    // -----------------------------------------------------------------
    //    OnMMTimer
    property OnMMTimer : TNotifyEvent read fOnMMTimer write fOnMMTimer;
    // -----------------------------------------------------------------
    //  : False -  ,
    //               True  -  ()
    property Cicle     : boolean read fCicle write fCicle;
    // -----------------------------------------------------------------
    // / .   " "
    //   OnMMTimer  Enabled   False.
    property Enabled   : boolean read fEnabled write RunTimerCicle;
    //  "  "
    property Stoped    : boolean read fStoped;
    property EvnID     : cardinal read fEvnID;
end;

// =========================================================================
implementation
// =========================================================================

//     , 
//     
//     (. procedure ProcTime)

type TRunExternalProc = procedure() of object;

// -------------------------------------------------------------------------
//   API \WINDOWS\SYSTEM32\WINMM.DLL
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// (WinMM API)
//  function timeSetEvent
// -------------------------------------------------------------------------
// uDelay      -     ( );
// uResolution -  ;  0 ,  
//                    
//                ;      
//                  ;
// IpTimeProc  -    ;
// dwUser      -  ,    
//                      
//               ;
// fuEvent     - ,    
//               :
//                    time_oneshot  (0) -     
//                                         uDelay ;
//                    time_periodic (1) -   
//                                         uDelay .
//
//         
//   0,    .
// -------------------------------------------------------------------------
function timeSetEvent
    (uDelay     : UINT;
     uReolution : UINT;
     IpTimeProc : Pointer;
     dwUser     : DWORD;
     fuEvent    : UINT): Integer; stdcall; external 'winmm.dll';
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//   (WinMM API)
//    function timeKillEvent
//    ,       
// -------------------------------------------------------------------------
//   
//  uID -   ,    timeSetEvent.
// -------------------------------------------------------------------------
function timeKillEvent
        (uiD: UINT): Integer; stdcall; external 'winmm.dll' ;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//   procedure ProcTime(uID,	msg: UINT; dwUse, dwi, dw2:	DWORD); stdcall;
//   
//       (  )
//           - 
//    "  "
// -------------------------------------------------------------------------
//  
// uID      -   ;
// uMsg     -  ;
// dwuser   -  ,    
//              (type DWORD = Longword;)
// dwi, dw2 -  .
// -------------------------------------------------------------------------
//    .
//   dwUse     
//       
//  .  ,    
//     ,    TMMTimer.RunExternalProc
//   .
// -------------------------------------------------------------------------
procedure ProcTime(uID,	msg: UINT; dwUse, dwi, dw2:	DWORD); stdcall;
var pW      :  ^pointer;
    pM      :  ^TMethod;
    Ob      :  TMMTimer;
begin
  if (dwUse > 0)
  then begin
    pW := pointer(dwUse);
    pM := pW^;
    try
      //       " "
      //     .     
      //   OnMMTimer ( ,  WinMM.dll)
      TRunExternalProc(pM^)();
    finally
      //    
      Ob := pM.Data;                           //    
      Ob.fEvnID := uID;
      if (Ob.fEnabled = False) or (Ob.fCicle = False)
      then begin
         if uID > 0 then timeKillEvent(uID);
         Ob.fEnabled := False;
         Ob.fStoped  := True;
      end;
    end;
  end;
end;
// -------------------------------------------------------------------------
//    TMMTimer
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
//      OnMMTimer
procedure TMMTimer.RunExternalProc();
begin
  if Assigned(fOnMMTimer) then fOnMMTimer(Self);
end;
// -------------------------------------------------------------------------
//    property Enabled
//   ,     timeSetEvent
//    CallBack     RunExternalProc
//    CallBack    .
//     RunTimerCicle.   
//       
// CallBack,   ProcTime.
//
procedure TMMTimer.RunTimerCicle(RqEnabled : boolean);
begin
   fStoped := False;
   if (fDelay > 0)
   then begin
      fEnabled := RqEnabled;
      fStoped  := not fEnabled;
      if fEnabled and Assigned(fOnMMTimer)
      then begin
          //      ProcTime  RunExternalProc
          //       
          fMhetod.Code := Addr(TMMTimer.RunExternalProc);
          fMhetod.Data := Self;       //    
          fpMhetod := Addr(fMhetod);  //  . . 
          //         fuID
          if fCicle
          then fuID := timeSetEvent(fDelay,0,@ProcTime,dword(Addr(fpMhetod)),1)
          else fuID := timeSetEvent(fDelay,0,@ProcTime,dword(Addr(fpMhetod)),0);

          if fuID = 0
          then begin
              ShowMessage('  MMTimer');
              fEnabled := False; //   
              fStoped  := True;
          end;
      end
      else begin
          //         (
          //   )  
          if fuID > 0
          then begin
             timeKillEvent(fuID);
             fuID := 0;
             fStoped  := True;
          end;
          fEnabled := False;  //   
          fStoped  := True;   //  - "  "
      end;
   end;
end;
// -------------------------------------------------------------------------
//  
constructor TMMTimer.Create();
begin
   inherited Create;
   FCicle    := False;
   fEnabled  := False;
end;
// -------------------------------------------------------------------------
//  
procedure TMMTimer.Free;
begin
   fDelay := 0;
   //   ,      
   if fuID > 0
   then begin
      timeKillEvent(fuID);
      fuID := 0;
   end;
   inherited Free;
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
end.
